## Analysis of colony fluorescence of populations from EE24 patched on LB agar with a pinning device over time
#analyse the mean or median of pixels of a colony (representing one population from one well)

#pre-processing:
#fiji/image J: use brightfield image for all 3 (YFP, CFP) to determine what a colony is: 
##16bit image>>adjust threshold (default)>analyze particles(2000px-infinity;0.5-1.0 roundness)
## save region of interest (ROI) manager >> zip. (of BF data and use for YFP,CFP !)
##>> positions in results matrix are the same!
##delete a few marked colonies that are outside the 96-well grid (when droplets spill and create an extra colony outside)

##file names:
#e.g. EE24.4C_30_CFP  = evolution experiment 24, day 4, evolved in 0.01% galactose (C), strain IT030, CFP fluorescence intensity


library("ggplot2")

##EE24 pins
setwd("/Users/itomanek/Documents/promoter_evolution/experiments/agar_plates/2019_agar_plates/EE24")

### read in files in a loop
filelist = list.files(pattern = ".*.txt")
for (i in 1:length(filelist)){ 
  x <- read.csv(filelist[i], header=TRUE, sep="\t") 
  assign(paste0(filelist[i]), x)
}#end loop


##Figure 4D - mutually exclusive mutations over time
dev.off()  
par(mfrow=c(2,2))
plot(EE24.1C_30_CFP.txt$median, EE24.1C_30_YFP.txt$median, col="black", ylim=c(5,15),xlim=c(79,200),cex=0.5) #ancestral
#d4
plot((EE24.4C_30_CFP.txt$median), EE24.4C_30_YFP.txt$median ,col="black", ylim=c(5,15),xlim=c(79,200),cex=0.5)
points(subset(EE24.4C_30_CFP.txt,Well=="A6")$median, subset(EE24.4C_30_YFP.txt,Well=="A6")$median ,col="red", ylim=c(5,25),xlim=c(79,200),pch=25)
points(subset(EE24.4C_30_CFP.txt,Well=="B2")$median, subset(EE24.4C_30_YFP.txt,Well=="B2")$median ,col="red", ylim=c(5,25),xlim=c(79,200),pch=25)
points(subset(EE24.4C_30_CFP.txt,Well=="C1")$median, subset(EE24.4C_30_YFP.txt,Well=="C1")$median ,col="red", ylim=c(5,25),xlim=c(79,200),pch=25)
points(subset(EE24.4C_30_CFP.txt,Well=="G1")$median, subset(EE24.4C_30_YFP.txt,Well=="G1")$median ,col="red", ylim=c(5,25),xlim=c(79,200),pch=25)
#d8
plot((EE24.8C_30_CFP.txt$median), EE24.8C_30_YFP.txt$median, label=EE24.8C_30_YFP.txt$Well,col="black", ylim=c(5,15),xlim=c(79,200),cex=0.5)
points(subset(EE24.8C_30_CFP.txt,Well=="A6")$median, subset(EE24.8C_30_YFP.txt,Well=="A6")$median ,col="red", ylim=c(5,25),xlim=c(79,200),pch=25)
points(subset(EE24.8C_30_CFP.txt,Well=="B2")$median, subset(EE24.8C_30_YFP.txt,Well=="B2")$median ,col="red", ylim=c(5,25),xlim=c(79,200),pch=25)
points(subset(EE24.8C_30_CFP.txt,Well=="C9")$median, subset(EE24.8C_30_YFP.txt,Well=="C9")$median ,col="grey", ylim=c(5,25),xlim=c(79,200),pch=25)
points(subset(EE24.8C_30_CFP.txt,Well=="C1")$median, subset(EE24.8C_30_YFP.txt,Well=="C1")$median ,col="red", ylim=c(5,25),xlim=c(79,200),pch=25)
points(subset(EE24.8C_30_CFP.txt,Well=="E10")$median, subset(EE24.8C_30_YFP.txt,Well=="E10")$median ,col="red", ylim=c(5,25),xlim=c(79,200),pch=25)
points(subset(EE24.8C_30_CFP.txt,Well=="F6")$median, subset(EE24.8C_30_YFP.txt,Well=="F6")$median ,col="red", ylim=c(5,25),xlim=c(79,200),pch=25)
points(subset(EE24.8C_30_CFP.txt,Well=="G1")$median, subset(EE24.8C_30_YFP.txt,Well=="G1")$median ,col="red", ylim=c(5,25),xlim=c(79,200),pch=25)
# pops that gained p* on day 12:
points(subset(EE24.8C_30_CFP.txt,Well=="B1")$median, subset(EE24.8C_30_YFP.txt,Well=="B1")$median ,col="orange", ylim=c(5,25),xlim=c(79,200),pch=25)
points(subset(EE24.8C_30_CFP.txt,Well=="D9")$median, subset(EE24.8C_30_YFP.txt,Well=="D9")$median ,col="orange", ylim=c(5,25),xlim=c(79,200),pch=25)
points(subset(EE24.8C_30_CFP.txt,Well=="D2")$median, subset(EE24.8C_30_YFP.txt,Well=="D2")$median ,col="orange", ylim=c(5,25),xlim=c(79,200),pch=25)
points(subset(EE24.8C_30_CFP.txt,Well=="E9")$median, subset(EE24.8C_30_YFP.txt,Well=="E9")$median ,col="orange", ylim=c(5,25),xlim=c(79,200),pch=25)
points(subset(EE24.8C_30_CFP.txt,Well=="G12")$median, subset(EE24.8C_30_YFP.txt,Well=="G12")$median ,col="orange", ylim=c(5,25),xlim=c(79,200),pch=25)
#d12
plot((EE24.12C_30_CFP.txt$median), EE24.12C_30_YFP.txt$median, label=EE24.12C_30_YFP.txt$Well,col="black", ylim=c(5,15),xlim=c(79,200),cex=0.5)
points(subset(EE24.12C_30_CFP.txt,Well=="A6")$median, subset(EE24.12C_30_YFP.txt,Well=="A6")$median ,col="red", ylim=c(5,25),xlim=c(79,200),pch=25)
points(subset(EE24.12C_30_CFP.txt,Well=="B2")$median, subset(EE24.12C_30_YFP.txt,Well=="B2")$median ,col="red", ylim=c(5,25),xlim=c(79,200),pch=25)
points(subset(EE24.12C_30_CFP.txt,Well=="C9")$median, subset(EE24.12C_30_YFP.txt,Well=="C9")$median ,col="grey", ylim=c(5,25),xlim=c(79,200),pch=25)#wrongly classified as Y+ (see FACS)
points(subset(EE24.12C_30_CFP.txt,Well=="C1")$median, subset(EE24.12C_30_YFP.txt,Well=="C1")$median ,col="red", ylim=c(5,25),xlim=c(79,200),pch=25)
points(subset(EE24.12C_30_CFP.txt,Well=="E10")$median, subset(EE24.12C_30_YFP.txt,Well=="E10")$median ,col="red", ylim=c(5,25),xlim=c(79,200),pch=25)
points(subset(EE24.12C_30_CFP.txt,Well=="F6")$median, subset(EE24.12C_30_YFP.txt,Well=="F6")$median ,col="blue", ylim=c(5,25),xlim=c(79,200),pch=25)
points(subset(EE24.12C_30_CFP.txt,Well=="G1")$median, subset(EE24.12C_30_YFP.txt,Well=="G1")$median ,col="red", ylim=c(5,25),xlim=c(79,200),pch=25)
points(subset(EE24.12C_30_CFP.txt,Well=="B1")$median, subset(EE24.12C_30_YFP.txt,Well=="B1")$median ,col="red", ylim=c(5,25),xlim=c(79,200),pch=25)
points(subset(EE24.12C_30_CFP.txt,Well=="C1")$median, subset(EE24.12C_30_YFP.txt,Well=="C1")$median ,col="red", ylim=c(5,25),xlim=c(79,200),pch=25)
points(subset(EE24.12C_30_CFP.txt,Well=="D2")$median, subset(EE24.12C_30_YFP.txt,Well=="D2")$median ,col="red", ylim=c(5,25),xlim=c(79,200),pch=25)
points(subset(EE24.12C_30_CFP.txt,Well=="G12C")$median, subset(EE24.12C_30_YFP.txt,Well=="G12C")$median ,col="red", ylim=c(5,25),xlim=c(79,200),pch=25)
points(subset(EE24.12C_30_CFP.txt,Well=="F10")$median, subset(EE24.12C_30_YFP.txt,Well=="F10")$median ,col="red", ylim=c(5,25),xlim=c(79,200),pch=25)
points(subset(EE24.12C_30_CFP.txt,Well=="E9")$median, subset(EE24.12C_30_YFP.txt,Well=="E9")$median ,col="red", ylim=c(5,25),xlim=c(79,200),pch=25)
points(subset(EE24.12C_30_CFP.txt,Well=="D9")$median, subset(EE24.12C_30_YFP.txt,Well=="D9")$median ,col="red", ylim=c(5,25),xlim=c(79,200),pch=25)
##F6 and C9 have become amplified (a part of the population became amplified)
#From the FACS it seems it has not been the promoter part 
#see below also


##get numbers
#all non-amplified 30C
na_30=which(EE24.4C_30_CFP.txt$median < 120)
#all non-amplified 30 YFP+ >=10
(unique(subset(EE24.4C_30_YFP.txt[na_30,],median >= 10)$Well)) #day 4:A6,B2,C1,G1
#all non-amplified 30C day 8
na_30=which(EE24.8C_30_CFP.txt$median < 120)
#all non-amplified 30 with YFP+ >=10
(unique(subset(EE24.8C_30_YFP.txt[na_30,],median >= 10)$Well)) #day 8: A6, B2, C9!, C1, E10, F6!, G1 (!... amplified later)
#all non-amlified 30C day 12
na_30=which(EE24.12C_30_CFP.txt$median < 120)
#all non-amplified 30 with YFP+ >=10
(unique(subset(EE24.12C_30_YFP.txt[na_30,],median >= 10)$Well)) #day 12: A6, B2, B1*, C1, D9*, D2*,E9*, E10, F10, G12*, G1  (*p gained from ancestral!)

## day 4 > day 8 
## 0 lost to amp
## day 8 > day 12
## 2 lost to amp; all that are gained, are gained from ancestral
## 2 lost: C9 (according to facs YFP plot never had a promoter, gained CFP d12)


#do amplified wells lose CFP?
#all non-amplified 30C day 8
A=EE24.8C_30_YFP.txt[which(EE24.8C_30_CFP.txt$median > 110),]$Well
B=EE24.12C_30_YFP.txt[which(EE24.12C_30_CFP.txt$median > 110),]$Well
A[!(A %in% B)]  # F10 not anymore in B
B[!(B %in% A)] #A7, B6, C9, C6, C3, D4, D11, D4, E3, F6, F12, F4,G11, G6, G5 pop up only in day12

plot(1,subset(EE24.8C_30_CFP.txt, Well=="F10")$median, xlim=c(0,4))
points(2,subset(EE24.12C_30_CFP.txt, Well=="F10")$median)  #F10 lost amplification



